/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.xml.contentassist;

import com.aptana.core.IMap;
import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.CollectionsUtil;
import com.aptana.editor.common.AbstractThemeableEditor;
import com.aptana.editor.common.CommonContentAssistProcessor;
import com.aptana.editor.common.contentassist.CommonCompletionProposal;
import com.aptana.editor.common.contentassist.ILexemeProvider;
import com.aptana.editor.xml.TagUtil;
import com.aptana.editor.xml.XMLPlugin;
import com.aptana.editor.xml.XMLTagScanner;
import com.aptana.editor.xml.contentassist.XMLAttributeProposal;
import com.aptana.editor.xml.contentassist.XMLTagProposal;
import com.aptana.editor.xml.internal.XMLLexemeProvider;
import com.aptana.parsing.lexer.IRange;
import com.aptana.parsing.lexer.Lexeme;
import com.aptana.parsing.lexer.Range;
import com.aptana.xml.core.index.XMLIndexQueryHelper;
import com.aptana.xml.core.model.AttributeElement;
import com.aptana.xml.core.model.ElementElement;
import com.aptana.xml.core.model.ValueElement;
import com.aptana.xml.core.parsing.XMLTokenType;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.swt.graphics.Image;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLContentAssistProcessor
extends CommonContentAssistProcessor {
    public static final Image ELEMENT_ICON = XMLPlugin.getImage("/icons/element.png");
    static final Image ATTRIBUTE_ICON = XMLPlugin.getImage("/icons/attribute.png");
    protected XMLIndexQueryHelper _queryHelper = this.createQueryHelper();
    protected Lexeme<XMLTokenType> _currentLexeme;
    private IRange _replaceRange;
    private IDocument _document;

    public XMLContentAssistProcessor(AbstractThemeableEditor editor) {
        super(editor);
    }

    protected XMLIndexQueryHelper createQueryHelper() {
        return new XMLIndexQueryHelper();
    }

    protected List<ICompletionProposal> addAttributeProposals(ILexemeProvider<XMLTokenType> lexemeProvider, int offset) {
        ElementElement element = this.getElement(lexemeProvider, offset);
        if (element == null) {
            return Collections.emptyList();
        }
        String postfix = "=\"\"";
        switch ((XMLTokenType)this._currentLexeme.getType()) {
            case EQUAL: {
                int index = lexemeProvider.getLexemeFloorIndex(offset);
                if (index <= 0) break;
                this._currentLexeme = lexemeProvider.getLexeme(index - 1);
                this._replaceRange = this._currentLexeme;
                postfix = "";
                break;
            }
            case END_TAG: {
                this._replaceRange = null;
                break;
            }
            default: {
                int index = lexemeProvider.getLexemeFloorIndex(offset);
                Lexeme nextlexeme = lexemeProvider.getLexeme(index + 1);
                if (nextlexeme == null || nextlexeme.getType() != XMLTokenType.EQUAL) break;
                postfix = "";
            }
        }
        int replaceLength = 0;
        if (this._replaceRange != null) {
            offset = this._replaceRange.getStartingOffset();
            replaceLength = this._replaceRange.getLength();
        }
        return CollectionsUtil.map((Collection)element.getAttributes(), (IMap)new AttributeProposalMapper(postfix, element, replaceLength, offset));
    }

    protected ElementElement getElement(ILexemeProvider<XMLTokenType> lexemeProvider, int offset) {
        String elementName = this.getElementName(lexemeProvider, offset);
        return this._queryHelper.getElement(elementName);
    }

    protected List<ICompletionProposal> addAttributeValueProposals(int offset, String elementName, String attributeName) {
        ArrayList<ICompletionProposal> proposals = new ArrayList<ICompletionProposal>();
        AttributeElement attribute = this._queryHelper.getAttribute(elementName, attributeName);
        if (attribute != null) {
            for (ValueElement value : attribute.getValues()) {
                String name = value.getName();
                Image icon = ATTRIBUTE_ICON;
                String description = value.getDescription();
                Image[] userAgentIcons = this.getAllUserAgentIcons();
                this.addProposal(proposals, name, icon, description, userAgentIcons, offset);
            }
        }
        return proposals;
    }

    private List<ICompletionProposal> addAttributeValueProposals(ILexemeProvider<XMLTokenType> lexemeProvider, int offset) {
        ArrayList<ICompletionProposal> proposals = new ArrayList<ICompletionProposal>();
        String attributeName = this.getAttributeName(lexemeProvider, offset);
        if (attributeName != null && attributeName.length() > 0) {
            switch ((XMLTokenType)this._currentLexeme.getType()) {
                case SINGLE_QUOTED_STRING: 
                case DOUBLE_QUOTED_STRING: {
                    if (this._currentLexeme.getLength() < 2) break;
                    int startingOffset = this._currentLexeme.getStartingOffset() + 1;
                    int endingOffset = this._currentLexeme.getEndingOffset() - 1;
                    this._replaceRange = new Range(startingOffset, endingOffset);
                    break;
                }
                case EQUAL: {
                    this._replaceRange = new Range(offset, offset - 1);
                    break;
                }
            }
            String elementName = this.getElementName(lexemeProvider, offset);
            proposals.addAll(this.addAttributeValueProposals(offset, elementName, attributeName));
        }
        return proposals;
    }

    private List<ICompletionProposal> addCloseTagProposals(ILexemeProvider<XMLTokenType> lexemeProvider, int offset) {
        List elements;
        ArrayList<ICompletionProposal> proposals = new ArrayList<ICompletionProposal>();
        Set<String> unclosedElements = this.getUnclosedTagNames(offset);
        if (unclosedElements != null && !unclosedElements.isEmpty()) {
            for (String unclosedElement : unclosedElements) {
                ElementElement element = this._queryHelper.getElement(unclosedElement);
                proposals.add((ICompletionProposal)this.createCloseTagProposal(element, offset));
            }
            if (!proposals.isEmpty()) {
                return proposals;
            }
        }
        if ((elements = this._queryHelper.getElements()) != null) {
            for (ElementElement element : elements) {
                proposals.add((ICompletionProposal)this.createCloseTagProposal(element, offset));
            }
        }
        return proposals;
    }

    protected List<ICompletionProposal> addElementProposals(ILexemeProvider<XMLTokenType> lexemeProvider, int offset) {
        List<ElementElement> elements = this.getElements(lexemeProvider, offset);
        if (elements == null) {
            return Collections.emptyList();
        }
        boolean close = true;
        int replaceLength = 0;
        int replaceOffset = offset;
        if (this._currentLexeme.getType() == XMLTokenType.END_TAG) {
            replaceLength = 1;
        } else if (this._currentLexeme.getType() != XMLTokenType.START_TAG) {
            Lexeme nextLexeme;
            int index = lexemeProvider.getLexemeCeilingIndex(this._currentLexeme.getEndingOffset() + 1);
            if (index == -1 || index >= lexemeProvider.size()) {
                index = lexemeProvider.size() - 1;
            }
            if ((nextLexeme = lexemeProvider.getLexeme(index)) != null) {
                replaceOffset = this._currentLexeme.getStartingOffset();
                replaceLength = this._currentLexeme.getLength();
                if (!nextLexeme.equals(this._currentLexeme)) {
                    if (nextLexeme.getType() == XMLTokenType.END_TAG) {
                        replaceLength += nextLexeme.getEndingOffset() - this._currentLexeme.getEndingOffset();
                    } else if (nextLexeme.getType() != XMLTokenType.START_TAG) {
                        close = false;
                    }
                }
            }
        }
        HashSet<String> uniques = new HashSet<String>(elements.size());
        boolean addCloseTag = true;
        String documentText = this._document.get();
        ArrayList<ICompletionProposal> proposals = new ArrayList<ICompletionProposal>();
        for (ElementElement element : elements) {
            String tagName = element.getName();
            if (uniques.contains(tagName)) continue;
            StringBuilder replacement = new StringBuilder(element.getName());
            ArrayList<Integer> positions = new ArrayList<Integer>();
            int cursorPosition = replacement.length();
            if (close) {
                if (element.getName().charAt(0) == '!') {
                    ++cursorPosition;
                    int index = lexemeProvider.getLexemeIndex(this._currentLexeme.getStartingOffset());
                    Lexeme nextLexeme = lexemeProvider.getLexeme(index + 1);
                    if (nextLexeme == null || nextLexeme.getType() == XMLTokenType.START_TAG) {
                        replacement.append(" >");
                    }
                } else if (this.isEmptyTagType(element)) {
                    replacement.append(" />");
                    positions.add(cursorPosition + " />".length());
                } else {
                    Document doc = new Document(documentText);
                    try {
                        doc.replace(replaceOffset, replaceLength, String.valueOf(element.getName()) + ">");
                    }
                    catch (BadLocationException e) {
                        IdeLog.logWarning((Plugin)XMLPlugin.getDefault(), (String)MessageFormat.format("Error replacing document text at offset {0} with text {1}", replaceOffset, String.valueOf(element.getName()) + ">"), (Throwable)e);
                    }
                    if (addCloseTag && !TagUtil.tagClosed((IDocument)doc, element.getName())) {
                        replacement.append("></").append(element.getName()).append('>');
                        positions.add(cursorPosition + 1);
                        positions.add(cursorPosition + 4 + element.getName().length());
                    } else {
                        replacement.append('>');
                        positions.add(cursorPosition + 1);
                    }
                }
            }
            positions.add(0, cursorPosition);
            XMLTagProposal proposal = this.createElementProposal(replaceLength, replaceOffset, element, replacement, positions);
            proposals.add((ICompletionProposal)proposal);
            uniques.add(tagName);
        }
        return proposals;
    }

    protected XMLTagProposal createElementProposal(int replaceLength, int replaceOffset, ElementElement element, StringBuilder replacement, List<Integer> positions) {
        return new XMLTagProposal(replacement.toString(), replaceOffset, replaceLength, element, positions.toArray(new Integer[positions.size()]));
    }

    private boolean isEmptyTagType(ElementElement element) {
        return false;
    }

    protected List<ElementElement> getElements(ILexemeProvider<XMLTokenType> lexemeProvider, int offset) {
        return this._queryHelper.getElements();
    }

    private void addProposal(List<ICompletionProposal> proposals, String name, Image image, String description, Image[] userAgents, int offset) {
        this.addProposal(proposals, name, image, description, userAgents, this.getCoreLocation(), offset);
    }

    private void addProposal(List<ICompletionProposal> proposals, String name, Image image, String description, Image[] userAgents, String fileLocation, int offset) {
        CommonCompletionProposal proposal = this.createProposal(name, image, description, userAgents, fileLocation, offset);
        proposals.add((ICompletionProposal)proposal);
    }

    private CommonCompletionProposal createCloseTagProposal(ElementElement element, int offset) {
        String replaceString = element.getName();
        int cursorPosition = replaceString.length();
        int replaceLength = 0;
        CommonCompletionProposal proposal = new CommonCompletionProposal(replaceString, offset, replaceLength, cursorPosition, ELEMENT_ICON, element.getName(), null, element.getDescription());
        proposal.setFileLocation(this.getCoreLocation());
        return proposal;
    }

    protected ILexemeProvider<XMLTokenType> createLexemeProvider(IDocument document, int offset) {
        int documentLength = document.getLength();
        int lexemeProviderOffset = offset >= documentLength ? documentLength - 1 : offset;
        return new XMLLexemeProvider(document, lexemeProviderOffset, 0, (ITokenScanner)new XMLTagScanner(){

            protected IToken createToken(XMLTokenType type) {
                return new Token((Object)type);
            }
        });
    }

    private CommonCompletionProposal createProposal(String name, Image image, String description, Image[] userAgents, String fileLocation, int offset) {
        return this.createProposal(name, name, image, description, userAgents, fileLocation, offset, name.length());
    }

    protected CommonCompletionProposal createProposal(String displayName, String name, Image image, String description, Image[] userAgents, String fileLocation, int offset, int length) {
        IContextInformation contextInfo = null;
        int replaceLength = 0;
        if (this._replaceRange != null) {
            offset = this._replaceRange.getStartingOffset();
            replaceLength = this._replaceRange.getLength();
        }
        CommonCompletionProposal proposal = new CommonCompletionProposal(name, offset, replaceLength, length, image, displayName, contextInfo, description);
        proposal.setFileLocation(fileLocation);
        proposal.setUserAgentImages(userAgents);
        proposal.setTriggerCharacters(this.getProposalTriggerCharacters());
        return proposal;
    }

    protected ICompletionProposal[] doComputeCompletionProposals(ITextViewer viewer, int offset, char activationChar, boolean autoActivated) {
        this._document = viewer.getDocument();
        ILexemeProvider<XMLTokenType> lexemeProvider = this.createLexemeProvider(this._document, offset > 0 ? offset - 1 : offset);
        Lexeme tempLexeme = lexemeProvider.getLexemeFromOffset(offset);
        if (tempLexeme != null) {
            this._currentLexeme = tempLexeme;
            this._replaceRange = this._currentLexeme;
        } else {
            this._replaceRange = null;
            this._currentLexeme = lexemeProvider.getFloorLexeme(offset);
        }
        LocationType location = this.getCoarseLocationType(lexemeProvider, offset);
        List<Object> result = Collections.emptyList();
        switch (location) {
            case IN_OPEN_TAG: {
                LocationType fineLocation = this.getFineTagLocationType(lexemeProvider, offset);
                switch (fineLocation) {
                    case IN_ELEMENT_NAME: {
                        result = this.addElementProposals(lexemeProvider, offset);
                        break;
                    }
                    case IN_ATTRIBUTE_NAME: {
                        result = this.addAttributeProposals(lexemeProvider, offset);
                        break;
                    }
                    case IN_ATTRIBUTE_VALUE: {
                        result = this.addAttributeValueProposals(lexemeProvider, offset);
                    }
                }
                break;
            }
            case IN_CLOSE_TAG: {
                result = this.addCloseTagProposals(lexemeProvider, offset);
                break;
            }
            default: {
                return NO_PROPOSALS;
            }
        }
        if (!CollectionsUtil.isEmpty(result)) {
            Collections.sort(result, new Comparator<ICompletionProposal>(){

                @Override
                public int compare(ICompletionProposal o1, ICompletionProposal o2) {
                    return o1.getDisplayString().compareToIgnoreCase(o2.getDisplayString());
                }
            });
            ICompletionProposal[] proposals = result.toArray(new ICompletionProposal[result.size()]);
            if (this._replaceRange != null) {
                try {
                    String text = this._document.get(this._replaceRange.getStartingOffset(), this._replaceRange.getLength());
                    this.setSelectedProposal(text, proposals);
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
            return proposals;
        }
        return NO_PROPOSALS;
    }

    private String getAttributeName(ILexemeProvider<XMLTokenType> lexemeProvider, int offset) {
        String name = null;
        int index = lexemeProvider.getLexemeFloorIndex(offset);
        while (index >= 0) {
            Lexeme lexeme = lexemeProvider.getLexeme(index);
            if (lexeme.getType() == XMLTokenType.EQUAL) {
                if (index < 1 || (lexeme = lexemeProvider.getLexeme(index - 1)) == null) break;
                name = lexeme.getText();
                break;
            }
            --index;
        }
        return name;
    }

    private LocationType getCoarseLocationType(ILexemeProvider<XMLTokenType> lexemeProvider, int offset) {
        if (this._currentLexeme == null) {
            return LocationType.ERROR;
        }
        Lexeme lexeme = this._currentLexeme;
        int index = lexemeProvider.getLexemeIndex(lexeme.getStartingOffset());
        while (true) {
            switch ((XMLTokenType)lexeme.getType()) {
                case DOCTYPE: {
                    return LocationType.IN_DOCTYPE;
                }
                case COMMENT: {
                    return LocationType.IN_COMMENT;
                }
                case CDATA: 
                case TEXT: {
                    return LocationType.IN_TEXT;
                }
                case START_TAG: {
                    if (lexeme.getText().endsWith("/")) {
                        return LocationType.IN_CLOSE_TAG;
                    }
                    return LocationType.IN_OPEN_TAG;
                }
                case TAG_SELF_CLOSE: {
                    return LocationType.IN_OPEN_TAG;
                }
            }
            if (--index < 0) break;
            lexeme = lexemeProvider.getLexeme(index);
        }
        return LocationType.ERROR;
    }

    private LocationType getFineTagLocationType(ILexemeProvider<XMLTokenType> lexemeProvider, int offset) {
        if (this._currentLexeme == null) {
            return LocationType.ERROR;
        }
        switch ((XMLTokenType)this._currentLexeme.getType()) {
            case START_TAG: {
                return LocationType.IN_ELEMENT_NAME;
            }
            case END_TAG: 
            case TAG_SELF_CLOSE: {
                int index = lexemeProvider.getLexemeIndex(offset);
                Lexeme previous = lexemeProvider.getLexeme(index - 1);
                if (previous == null) {
                    return LocationType.ERROR;
                }
                switch ((XMLTokenType)previous.getType()) {
                    case SINGLE_QUOTED_STRING: 
                    case DOUBLE_QUOTED_STRING: {
                        return LocationType.IN_ATTRIBUTE_NAME;
                    }
                    case EQUAL: {
                        return LocationType.IN_ATTRIBUTE_VALUE;
                    }
                    case START_TAG: {
                        return LocationType.IN_ELEMENT_NAME;
                    }
                    case TAG_NAME: {
                        if (previous.isContiguousWith(this._currentLexeme)) {
                            this._currentLexeme = previous;
                            this._replaceRange = this._currentLexeme;
                            return LocationType.IN_ELEMENT_NAME;
                        }
                        return LocationType.IN_ATTRIBUTE_NAME;
                    }
                    case ATTRIBUTE: {
                        if (previous.isContiguousWith(this._currentLexeme)) {
                            this._currentLexeme = previous;
                            this._replaceRange = this._currentLexeme;
                        }
                        return LocationType.IN_ATTRIBUTE_NAME;
                    }
                }
                return LocationType.IN_ATTRIBUTE_NAME;
            }
            case ATTRIBUTE: {
                return LocationType.IN_ATTRIBUTE_NAME;
            }
            case EQUAL: {
                if (offset == this._currentLexeme.getStartingOffset()) {
                    return LocationType.IN_ATTRIBUTE_NAME;
                }
                return LocationType.IN_ATTRIBUTE_VALUE;
            }
            case SINGLE_QUOTED_STRING: 
            case DOUBLE_QUOTED_STRING: {
                if (offset > this._currentLexeme.getEndingOffset() + 1) {
                    return LocationType.IN_ATTRIBUTE_NAME;
                }
                return LocationType.IN_ATTRIBUTE_VALUE;
            }
            case TAG_NAME: {
                if (offset > this._currentLexeme.getEndingOffset() + 1) {
                    return LocationType.IN_ATTRIBUTE_NAME;
                }
                return LocationType.IN_ELEMENT_NAME;
            }
        }
        return LocationType.ERROR;
    }

    protected String getCoreLocation() {
        return "XML Core";
    }

    protected String getElementName(ILexemeProvider<XMLTokenType> lexemeProvider, int offset) {
        int index;
        String result = null;
        int i = index = lexemeProvider.getLexemeFloorIndex(offset);
        while (i >= 0) {
            Lexeme lexeme = lexemeProvider.getLexeme(i);
            if (lexeme.getType() == XMLTokenType.TAG_NAME) {
                result = lexeme.getText();
                break;
            }
            --i;
        }
        if (result != null) {
            if (result.startsWith("<")) {
                result = result.substring(1);
            }
            if (result.endsWith(">")) {
                result = result.substring(0, result.length() - 1);
            }
            if ((result = result.trim()).indexOf(32) != -1) {
                result = result.substring(0, result.indexOf(32));
                result = result.trim();
            }
        }
        return result;
    }

    protected Set<String> getUnclosedTagNames(int offset) {
        HashSet<String> unclosedElements = new HashSet<String>();
        try {
            ITypedRegion[] partitions;
            ITypedRegion[] iTypedRegionArray = partitions = this._document.computePartitioning(0, offset);
            int n = partitions.length;
            int n2 = 0;
            while (n2 < n) {
                String[] parts;
                String src;
                int lessThanIndex;
                ITypedRegion partition = iTypedRegionArray[n2];
                if (!partition.getType().equals("__xml_tag") || (lessThanIndex = (src = this._document.get(partition.getOffset(), partition.getLength())).indexOf(60)) == -1 || lessThanIndex >= src.length() - 1 || (parts = (src = src.substring(lessThanIndex + 1).trim()).split("\\W")) == null || parts.length == 0) {
                    // empty if block
                }
                ++n2;
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return unclosedElements;
    }

    protected String getPreferenceNodeQualifier() {
        return "com.aptana.editor.xml";
    }

    public boolean isValidAutoActivationLocation(char c, int keyCode, IDocument document, int offset) {
        ILexemeProvider<XMLTokenType> lexemeProvider = this.createLexemeProvider(document, offset);
        LocationType location = this.getCoarseLocationType(lexemeProvider, offset);
        switch (location) {
            case IN_OPEN_TAG: {
                if (c == ' ' || c == '\t') {
                    return true;
                }
                LocationType fineLocation = this.getFineTagLocationType(lexemeProvider, offset);
                return fineLocation == LocationType.IN_ATTRIBUTE_NAME || fineLocation == LocationType.IN_ATTRIBUTE_VALUE;
            }
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class AttributeProposalMapper
    implements IMap<String, ICompletionProposal> {
        private final String suffix;
        private final ElementElement element;
        private final int length;
        private final int theOffset;

        private AttributeProposalMapper(String suffix, ElementElement element, int length, int theOffset) {
            this.suffix = suffix;
            this.element = element;
            this.length = length;
            this.theOffset = theOffset;
        }

        public ICompletionProposal map(String attribute) {
            String replaceString = String.valueOf(attribute) + this.suffix;
            int[] positions = this.suffix.length() == 0 ? new int[]{replaceString.length()} : new int[]{replaceString.length() - 1, replaceString.length()};
            AttributeElement attr = XMLContentAssistProcessor.this._queryHelper.getAttribute(this.element.getName(), attribute);
            return new XMLAttributeProposal(attr, replaceString, this.theOffset, this.length, positions);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum LocationType {
        ERROR,
        IN_OPEN_TAG,
        IN_CLOSE_TAG,
        IN_DOCTYPE,
        IN_COMMENT,
        IN_TEXT,
        IN_ELEMENT_NAME,
        IN_ATTRIBUTE_NAME,
        IN_ATTRIBUTE_VALUE;

    }
}

